/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.events.thecity;

import com.megacrit.cardcrawl.cards.colorless.JAX;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.events.AbstractEvent;
import com.megacrit.cardcrawl.events.AbstractImageEvent;
import com.megacrit.cardcrawl.events.GenericEventDialog;
import com.megacrit.cardcrawl.helpers.CardLibrary;
import com.megacrit.cardcrawl.localization.EventStrings;
import com.megacrit.cardcrawl.unlock.UnlockTracker;
import com.megacrit.cardcrawl.vfx.cardManip.ShowCardAndObtainEffect;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DrugDealer
extends AbstractImageEvent {
    private static final Logger logger = LogManager.getLogger(DrugDealer.class.getName());
    public static final String ID = "Drug Dealer";
    private static final EventStrings eventStrings = CardCrawlGame.languagePack.getEventString("Drug Dealer");
    public static final String NAME = DrugDealer.eventStrings.NAME;
    public static final String[] DESCRIPTIONS = DrugDealer.eventStrings.DESCRIPTIONS;
    public static final String[] OPTIONS = DrugDealer.eventStrings.OPTIONS;
    private static final int GOLD_COST = 100;
    private static final String INTRO_BODY = DESCRIPTIONS[0];
    private static final String ACCEPT_BODY = DESCRIPTIONS[1];
    private static final String REJECT_BODY = DESCRIPTIONS[2];
    private int screenNum = 0;

    public DrugDealer() {
        super(NAME, INTRO_BODY, "images/events/drugDealer.jpg");
        if (AbstractDungeon.player.gold >= 100) {
            GenericEventDialog.setDialogOption(OPTIONS[0] + 100 + OPTIONS[1], AbstractDungeon.player.gold < 100, CardLibrary.getCopy("J.A.X."));
        } else {
            GenericEventDialog.setDialogOption(OPTIONS[2] + 100 + OPTIONS[3], AbstractDungeon.player.gold < 100);
        }
        GenericEventDialog.setDialogOption(OPTIONS[5]);
    }

    @Override
    protected void buttonEffect(int buttonPressed) {
        switch (this.screenNum) {
            case 0: {
                switch (buttonPressed) {
                    case 1: {
                        this.logMetric("Ignored");
                        GenericEventDialog.updateBodyText(REJECT_BODY);
                        GenericEventDialog.updateDialogOption(0, OPTIONS[4]);
                        GenericEventDialog.clearRemainingOptions();
                        break;
                    }
                    case 0: {
                        GenericEventDialog.updateBodyText(ACCEPT_BODY);
                        if (AbstractDungeon.player.gold < 100) break;
                        this.logMetric("Got JAXXED");
                        AbstractDungeon.player.loseGold(100);
                        UnlockTracker.markCardAsSeen("J.A.X.");
                        AbstractDungeon.effectList.add(new ShowCardAndObtainEffect(new JAX(), Settings.WIDTH / 2, Settings.HEIGHT / 2));
                        GenericEventDialog.updateDialogOption(0, OPTIONS[4]);
                        GenericEventDialog.clearRemainingOptions();
                        break;
                    }
                    default: {
                        logger.info("ERROR: Unhandled case " + buttonPressed);
                    }
                }
                this.screenNum = 1;
                break;
            }
            case 1: {
                this.openMap();
            }
        }
    }

    public void logMetric(String actionTaken) {
        AbstractEvent.logMetric(ID, actionTaken);
    }
}

